/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class StorageUtil
implements StorageConstants {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static boolean s_isOCFSsupported;
    private static int OCFS_TYPE;

    public static boolean isValidStorageType(String[] nodeList, StorageInfo stInfo, OracleFileType usageType, String release, boolean considerASMStorage) throws StorageException {
        String nodeListStr = VerificationUtil.strArr2List(nodeList);
        Trace.out((String)("nodeList=" + nodeListStr + "; path=" + stInfo.getPath() + "; type=" + stInfo.getTypeStr()));
        int[] supportedStorageTypes = sStorageUtil.getSupportedFileTypes(usageType, release, considerASMStorage);
        ArrayList<String> supportStorageTypesStr = new ArrayList<String>();
        for (int supportStorageType : supportedStorageTypes) {
            supportStorageTypesStr.add(sStorageUtil.getTypeStr(supportStorageType));
        }
        boolean supported = false;
        for (int supportedType : supportedStorageTypes) {
            if (stInfo.getType() != supportedType) continue;
            Trace.out((String)("The file type '" + stInfo.getTypeStr() + "' is found suitable for: " + usageType.name()));
            supported = true;
            break;
        }
        if (!supported) {
            Trace.out((String)("The file type for '" + stInfo.getPath() + "' is not found suitable for:" + usageType.name()));
            HashMap<String, String> h = VerifyStorage.getUnsuitableTypeMessage(usageType);
            throw new StorageException(h.values().iterator().next(), true, (Object[])new String[]{stInfo.getPath(), stInfo.getTypeStr(), release, VerificationUtil.strCollection2String(supportStorageTypesStr, ", ")}, h.keySet().iterator().next());
        }
        if (stInfo.getType() == 14) {
            try {
                String[] rimNodes;
                NodeManager nm = NodeManagerFactory.getInstance().getNodeManager();
                if (nm.isBigCluster() && (rimNodes = nm.getNodes(nodeList, NodeRoleCapability.RIM)) != null) {
                    Trace.out((String)"ACFS path %s is not suitable for rim nodes %s", (Object[])new Object[]{stInfo.getPath(), VerificationUtil.strArr2List(rimNodes)});
                    throw new StorageException("11500", true, (Object[])new String[]{stInfo.getPath(), VerificationUtil.strArr2List(rimNodes)}, "Prvg");
                }
            }
            catch (NodeManagerFactoryException e) {
                Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            }
            catch (NoSuchNodesException e) {
                Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            }
            catch (NodeManagerException e) {
                Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            }
        }
        return true;
    }

    public static List<String> expandDevicePaths(String node, String[] deviceString) {
        Trace.out((int)2, (String)"Entry");
        ArrayList<String> deviceListAll = new ArrayList<String>();
        for (String device : deviceString) {
            List m_deviceList = new ArrayList();
            if (VerificationUtil.containsWildCard(device)) {
                GlobalExecution globalExec = new GlobalExecution();
                ResultSet rsltSet = new ResultSet();
                if (node == null) {
                    try {
                        node = VerificationUtil.getLocalHost();
                    }
                    catch (UnknownHostException uhe) {
                        Trace.out((String)("UNKNOWNHOSTEXCEPTION: \n" + uhe));
                        String errMsg = s_msgBundle.getMessage("0002", true);
                        ReportUtil.sureprintln(errMsg);
                        return deviceListAll;
                    }
                }
                String cmd = null;
                NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                cmd = nativeSystem.isUnixSystem() ? "'" + VerificationUtil.getFileListCommand() + " " + device + "'" : VerificationUtil.getFileListCommand() + " " + device;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("expandDevicePaths: Command is : " + cmd));
                }
                globalExec.runGenericCmd(new String[]{node}, cmd, rsltSet);
                Result result = rsltSet.getResult(node);
                if (result.getStatus() == 1 || result.getStatus() == 4) {
                    String outStr = (String)result.getResultInfoSet().firstElement();
                    Trace.out((String)("outStr=" + outStr));
                    String exitStat = VerificationUtil.fetchVerificationResult(outStr);
                    Trace.out((String)("exitStat=" + exitStat));
                    if (exitStat != null && exitStat.contentEquals("0")) {
                        String[] cmdOut = (String[])result.getResultInfoSet().get(1);
                        m_deviceList = VerificationUtil.parseFileListOutput(cmdOut);
                        if (Trace.isLevelEnabled((int)5)) {
                            for (int i = 0; i < cmdOut.length; ++i) {
                                Trace.out((String)("expandDevicePaths: Command output is : " + cmdOut[i]));
                            }
                        }
                        deviceListAll.addAll(m_deviceList);
                        continue;
                    }
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Failed to expand wildcarded device string " + device));
                    }
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5193", true, (Object[])new String[]{device}));
                    continue;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Wildcard expansion operation failed for device string " + device));
                }
                ReportUtil.sureprintln(s_msgBundle.getMessage("5193", true, (Object[])new String[]{device}));
                continue;
            }
            deviceListAll.add(device);
        }
        return deviceListAll;
    }

    public static Set<String> expandDevicePaths(String[] nodeList, String[] deviceString) {
        HashSet<String> expandedDevicePathSet = new HashSet<String>();
        for (String node : nodeList) {
            List<String> expandedDevicePathNode = StorageUtil.expandDevicePaths(node, deviceString);
            if (expandedDevicePathNode == null) continue;
            expandedDevicePathSet.addAll(expandedDevicePathNode);
        }
        return expandedDevicePathSet;
    }

    public static boolean isRawDiscoveryEnabled() {
        boolean enabled = true;
        String configVal = VerificationUtil.getConfiguredValue("CV_RAW_CHECK_ENABLED", false);
        if (null != configVal && configVal.equalsIgnoreCase("FALSE")) {
            enabled = false;
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("RawDiscovery enabled? " + enabled));
        }
        return enabled;
    }

    public static String getTypeStr(int type) {
        switch (type) {
            case 1: {
                return "Disk";
            }
            case 2: {
                return "NFS";
            }
            case 5: {
                return "File System";
            }
            case 3: {
                return "Vx Disk Group";
            }
            case 4: {
                return "Vx Volume";
            }
            case 11: {
                return "Native DG";
            }
            case 12: {
                return "Native LV";
            }
            case 10: {
                return "GPFS(mmfs)";
            }
            case 15: {
                return "SAM File System";
            }
            case 16: {
                return "Quick File System";
            }
            case 6: {
                return "Disk Partition";
            }
            case 7: {
                return "ocfs";
            }
            case 8: {
                return "ocfs2";
            }
            case 14: {
                return "ACFS";
            }
            case 17: {
                return "VXFS";
            }
            case 13: {
                return "ASM Disk Group";
            }
        }
        return "Unknown";
    }

    public static StorageType getTypeEnum(int type) {
        switch (type) {
            case 1: {
                return StorageType.DISK;
            }
            case 6: {
                return StorageType.DISK_PARTITION;
            }
            case 2: {
                return StorageType.NFS;
            }
            case 5: {
                return StorageType.FILESYSTEM;
            }
            case 3: {
                return StorageType.VXDG;
            }
            case 4: {
                return StorageType.VXVOLUME;
            }
            case 11: {
                return StorageType.LVMDG;
            }
            case 12: {
                return StorageType.LVMLV;
            }
            case 10: {
                return StorageType.GPFS;
            }
            case 7: {
                return StorageType.OCFS;
            }
            case 8: {
                return StorageType.OCFS2;
            }
            case 15: {
                return StorageType.SAMFS;
            }
            case 16: {
                return StorageType.QFS;
            }
            case 14: {
                return StorageType.ACFS;
            }
            case 13: {
                return StorageType.ASMDG;
            }
            case 17: {
                return StorageType.VXFS;
            }
        }
        return StorageType.UNKNOWN;
    }

    public static int getTypeByStr(String str) throws StorageException {
        int type = -1;
        if (str.equals("FS")) {
            type = 5;
        } else if (str.equals("DISK")) {
            type = 1;
        } else if (str.equals("SCSI")) {
            type = 1;
        } else if (str.equals("VXVOLUME")) {
            type = 4;
        } else if (str.equals("NFS")) {
            type = 2;
        } else if (str.equals("NFS3")) {
            type = 2;
        } else if (str.equals("SAMFS")) {
            type = 15;
        } else if (str.equals("QFS")) {
            type = 16;
        } else if (str.equals("GPFS")) {
            type = 10;
        } else if (str.equals("IBMDG") || str.equals("HPXDG")) {
            type = 11;
        } else if (str.equals("IBMLV") || str.equals("HPXLV")) {
            type = 12;
        } else if (str.equals("OCFS")) {
            type = s_isOCFSsupported ? 7 : 8;
        } else if (str.equals("OCFS2")) {
            type = 8;
        } else if (str.equals("ACFS")) {
            type = 14;
        } else if (str.equals("ASM")) {
            type = 13;
        } else if (str.equals("VXFS")) {
            type = 17;
        } else {
            Trace.out((String)("_st_:String " + str + " is not a recognized type."));
            throw new StorageException();
        }
        return type;
    }

    static {
        OCFS_TYPE = 8;
        String distID = VerificationUtil.getUniqueDistributionID();
        boolean bl = s_isOCFSsupported = distID.equalsIgnoreCase("RHEL3") || distID.equalsIgnoreCase("OEL3") || distID.equalsIgnoreCase("RHEL2");
        if (s_isOCFSsupported) {
            OCFS_TYPE = 7;
        }
    }
}

